<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsCoursesListing extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-courses-listing';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Courses Listing', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-grid';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'courses listing' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Courses Listing', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'background_image',
            [
                'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        ); 
        $this->add_control(
            'subheading',
            [
                'label'       => __( 'Subheading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subheading', 'bdevs-elementor' ),
                'default'     => __( 'This is subheading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'This is heading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'posts_per_page',
            [
                'label'       => __( 'Posts Per Page:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your posts per page', 'bdevs-elementor' ),
                'default'     => __( '12', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'sortby',
            [
                'label'     => esc_html__( 'Sort', 'bdevs-elementor' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'sortby_style_1'  => esc_html__( 'Newest', 'bdevs-elementor' ),
                    'sortby_style_2'  => esc_html__( 'Oldest', 'bdevs-elementor' ),
                ],
                'default'   => 'sortby_style_1',
            ]
        );
        $this->end_controls_section();
        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        ); 
        $this->end_controls_section();
    }
    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); 
    if ($settings['sortby']=='sortby_style_1') {
        $sortby = 'DESC';
    }
    if ($settings['sortby']=='sortby_style_2') {
        $sortby = 'ASC';
    }
    ?>
    <!-- Start Cources Section -->
    <section class="our-cources sub padding-lg">
      <style type="text/css">
        .our-cources:after{
            background: url(<?php echo wp_kses_post($settings['background_image']['url']); ?>) no-repeat center top / cover;
        }
      </style>
      <div class="container">
        <div class="row">
          <div class="col-sm-8">
            <?php if ( $settings['show_heading'] ) : ?>
                <h2>
                    <?php if(isset($settings['subheading']) && $settings['subheading'] != ''){?>
                    <span><?php print wp_kses_post($settings['subheading']); ?></span>
                    <?php } ?>
                    <?php print wp_kses_post($settings['heading']); ?> 
                </h2>
                <?php endif; ?>
          </div>
          <div class="col-sm-4">
            <div class="select-course isotopeFilters">
              <ul class="gallery-filter courses-listing">
                <li class="active"><a href="#" data-filter="*"><?php echo esc_html__( 'All', 'edumart' );?></a></li>
                <?php 
                  $types = get_terms('type2');   
                  foreach( (array)$types as $type){
                    $type_name = $type->name;
                    $type_slug = $type->slug;
                ?>
                <li><a href="#" data-filter=".<?php echo esc_attr($type_slug);?>"><?php echo esc_attr($type_name);?></a></li>
                <?php } ?>
              </ul>
            </div>
          </div>
        </div>
        <ul class="row course-list inner isotopeContainer">
          <?php
          $posts_per_page = $settings['posts_per_page'];
          $wp_query = new \WP_Query(array('posts_per_page' => $posts_per_page,'post_type' => 'course',  'orderby' => 'ID', 'order' => $sortby));     
          $args = new \WP_Query(array(   
                      'post_type' => 'course', 
                  ));  
          while ($wp_query -> have_posts()) : $wp_query -> the_post();   
          $description = get_post_meta(get_the_ID(),'_cmb_description', true); 
          $fees_title = get_post_meta(get_the_ID(),'_cmb_fees_title', true); 
          $fees_amount = get_post_meta(get_the_ID(),'_cmb_fees_amount', true); 
          $duration = get_post_meta(get_the_ID(),'_cmb_duration', true); 
          $duration_title = get_post_meta(get_the_ID(),'_cmb_duration_title', true); 
          $typs = get_the_terms(get_the_ID(),'type2');
            $typ_slug = '';
            foreach((array)$typs as $typ){
                $typ_slug .= $typ->slug .' '; 
            }
          ?>
          <li class="col-xs-6 col-sm-4 col-md-3 isotopeSelector <?php echo esc_attr($typ_slug);?>">
            <div class="inner">
              <figure><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt=""></figure>
              <h3><?php the_title(); ?></h3>
              <p><?php echo wp_specialchars_decode(esc_attr($description));?></p>
              <div class="fess-box"><?php echo wp_specialchars_decode(esc_attr($fees_title));?><span> <?php echo wp_specialchars_decode(esc_attr($fees_amount));?></span> </div>
              <div class="bottom-txt clearfix">
                <div class="duration">
                  <h4><?php echo wp_specialchars_decode(esc_attr($duration));?></h4>
                  <span> <?php echo wp_specialchars_decode(esc_attr($duration_title));?></span> </div>
                <a href="<?php the_permalink();?>"><span class="icon-more-icon"></span></a> </div>
            </div>
          </li>
          <?php endwhile; ?>
        </ul>
      </div>
    </section>
    <!-- End Cources Section --> 
      <?php
    }
}


