<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsContactAddress extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-contact-address';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Contact Address', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-headphones';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'contact address' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Contact Address', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'address',
            [
                'label'       => __( 'Address:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your address', 'bdevs-elementor' ),
                'default'     => __( 'This is address ', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'address_detail',
            [
                'label'       => __( 'Address Detail:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your address detail', 'bdevs-elementor' ),
                'default'     => __( 'This is address detail', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'phone',
            [
                'label'       => __( 'Phone:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your phone', 'bdevs-elementor' ),
                'default'     => __( 'This is phone', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'email',
            [
                'label'       => __( 'Email:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your email', 'bdevs-elementor' ),
                'default'     => __( 'This is email', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );         
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Socials:', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'icon',
                        'label'       => esc_html__( 'Icon:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is icon' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'link',
                        'label'       => esc_html__( 'Link:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '#' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->end_controls_section();

    }

    public function render() {
        $settings  = $this->get_settings_for_display();
        extract($settings); 
        ?>
        <section class="google-map">
            <div class="container">
                <div class="contact-detail">
                    <div class="address">
                        <div class="inner">
                            <?php if(isset($settings['address']) && $settings['address'] != ''){?>
                            <h3><?php print wp_kses_post($settings['address']); ?></h3>
                            <?php } ?>
                            <?php if(isset($settings['address_detail']) && $settings['address_detail'] != ''){?>
                            <p><?php print wp_kses_post($settings['address_detail']); ?></p>
                            <?php } ?>
                        </div>
                        <?php if(isset($settings['phone']) && $settings['phone'] != ''){?>
                        <div class="inner">
                          <h3><?php print wp_kses_post($settings['phone']); ?></h3>
                        </div>
                        <?php } ?>
                        <?php if(isset($settings['email']) && $settings['email'] != ''){?>
                        <div class="inner"> <a href="mailto:<?php print wp_kses_post($settings['email']); ?>"><?php print wp_kses_post($settings['email']); ?></a> 
                        </div>
                        <?php } ?>
                    </div>
                    <div class="contact-bottom">
                        <ul class="follow-us clearfix">
                            <?php foreach ( $settings['tabs'] as $item ) : ?>
                            <li><a href="<?php print wp_kses_post($item['link']); ?>"><i class="<?php print wp_kses_post($item['icon']); ?>" aria-hidden="true"></i></a></li>
                            <?php endforeach; ?> 
                        </ul>
                    </div>
                </div>
            </div>
        </section>
    <?php
    }
}


